define(['app', 'angular'], function (app, angular) {
	app.directive('imageLightbox', function ($modal, $timeout, focusService) {
		return {
			restrict: 'A',
			scope: {
				headerText: '@'
			},
			link: function (scope, element, attrs) {
				element.attr('tabindex', '-1');
				
				// Image 'src' attribute is set as data-src on the directive to prevent browser from requesting
				// images all the time. We only want images requested on medium form factors and above.
				if (window.innerWidth >= 768) {
					element.attr('src', attrs.src);
				}

				element.on('click', function (event) {
					var modalInstance = $modal.open({
						windowClass: 'image-lightbox',
						templateUrl: 'src/ui-components/image/image-lightbox_template.html',
						controller: 'ImageLightboxModal',
						resolve: {
							imageSource: function () { return attrs.src.replace('thumbnails/', ''); },
							imageAlt: function () { return attrs.alt },
							headerText: function () { return scope.headerText }
						}
					});

					modalInstance.opened.then(function (result) {
						$timeout(function () {
							var modalDialog = angular.element('.image-lightbox .modal-dialog'),
								img = angular.element('.image-lightbox .modal-dialog img');

							img.bind('load', function (event) {
								modalDialog.attr('style', 'width: ' + img[0].naturalWidth + 'px');
							});

							focusService.focusElement(angular.element('div.modal-header h4'));
						});
					});

					modalInstance.result.then(function () {
						focusService.focusElement(element);
					});
				});
			}
		}
	});

	app.controller('ImageLightboxModal', function ($scope, $modalInstance, imageSource, imageAlt, headerText) {
		$scope.imageSource = imageSource;
		$scope.imageAlt = imageAlt;
		$scope.header = headerText;

		$scope.close = function () {
			$modalInstance.close('close');
		}
	});
});